﻿using CalamityMod.Projectiles.Melee;
using Microsoft.Xna.Framework;
using Terraria;
using Terraria.DataStructures;
using Terraria.ID;
using Terraria.ModLoader;

namespace CalamityMod.Items.Weapons.Melee
{
    public class BladecrestOathsword : ModItem, ILocalizedModType
    {
        public new string LocalizationCategory => "Items.Weapons.Melee";
        public override void SetDefaults()
        {
            Item.width = 56;
            Item.height = 56;
            Item.damage = 17;
            Item.DamageType = DamageClass.Melee;
            Item.useAnimation = 21;
            Item.useTime = 21;
            Item.useStyle = ItemUseStyleID.Shoot;
            Item.knockBack = 4f;
            Item.UseSound = SoundID.Item1;
            Item.autoReuse = true;
            Item.noUseGraphic = true;
            Item.useTurn = false;
            Item.channel = true;
            Item.value = CalamityGlobalItem.RarityOrangeBuyPrice;
            Item.rare = ItemRarityID.Orange;
            Item.shootSpeed = 6f;
            // Set so the item isn't classified as true melee
            Item.shoot = ModContent.ProjectileType<BladecrestOathswordProj>();
        }

        public override bool CanUseItem(Player player)
        {
            int bladeProjID = ModContent.ProjectileType<BladecrestOathswordProj>();
            foreach (Projectile p in Main.ActiveProjectiles)
            {
                if (p.type != bladeProjID || p.owner != player.whoAmI)
                    continue;

                return p.ModProjectile<BladecrestOathswordProj>().PostSwingRepositionDelay <= 0f;
            }

            return base.CanUseItem(player);
        }

        // Return false because Shoot code is not actually relevant
        public override bool Shoot(Player player, EntitySource_ItemUse_WithAmmo spawnSource, Vector2 position, Vector2 velocity, int type, int damage, float knockback) => false;

        public override bool? CanHitNPC(Player player, NPC target) => false;

        public override bool CanHitPvp(Player player, Player target) => false;
    }
}
