﻿using CalamityMod.NPCs;
using CalamityMod.Particles;
using Terraria;
using Terraria.DataStructures;
using Terraria.ID;
using Terraria.ModLoader;
using Microsoft.Xna.Framework;
using ReLogic.Utilities;
using CalamityMod.Dusts;

namespace CalamityMod.Buffs.DamageOverTime
{
    public class VulnerabilityHex : ModBuff
    {
        // This is the visual number displayed in ticks as the enemy takes damage from this debuff.
        public const int TickNumber = 666;

        // This is the exact DPS dealt by Vulnerability Hex to NPCs.
        public const int DPS = TickNumber * 4; // 2664 DPS

        public const int CalamityDuration = 24;
        public const int AflameDuration = 120;

        public override void SetStaticDefaults()
        {
            Main.debuff[Type] = true;
            Main.pvpBuff[Type] = true;
            Main.buffNoSave[Type] = true;
            BuffID.Sets.NurseCannotRemoveDebuff[Type] = true;
            BuffID.Sets.LongerExpertDebuff[Type] = true;
        }

        public override void Update(Player player, ref int buffIndex) => player.Calamity().vHex = true;

        public override void Update(NPC npc, ref int buffIndex)
        {
            CalamityGlobalNPC cgn = npc.Calamity();
            if (cgn.vulnerabilityHex < npc.buffTime[buffIndex])
            {
                cgn.vulnerabilityHex = npc.buffTime[buffIndex];
                // Set the remaining time of the fire drawer to be exactly right.
                if (cgn.VulnerabilityHexFireDrawer != null)
                    cgn.VulnerabilityHexFireDrawer.SetLifetime = cgn.VulnerabilityHexFireDrawer.LocalTimer + cgn.vulnerabilityHex;
            }

            // Apply immunity timer.
            if ((CalamityLists.enemyImmunityList.Contains(npc.type) || npc.boss) && cgn.debuffResistanceTimer <= 0)
                cgn.debuffResistanceTimer = CalamityGlobalNPC.slowingDebuffResistanceMin + cgn.vulnerabilityHex;

            // Destroy the vanilla buff, we don't use it.
            npc.DelBuff(buffIndex);
            buffIndex--;
        }
        internal static void DrawEffects(PlayerDrawSet drawInfo)
        {
            Player Player = drawInfo.drawPlayer;

            if (Main.rand.NextBool())
            {
                VoidSparkParticle spark2 = new VoidSparkParticle(Player.Calamity().RandomDebuffVisualSpot, new Vector2(0, Main.rand.NextFloat(-6f, -10f)), false, Main.rand.Next(18, 27), Main.rand.NextFloat(0.015f, 0.045f), Main.rand.NextBool() ? Color.Red : Color.Lerp(Color.Red, Color.Magenta, 0.65f));
                GeneralParticleHandler.SpawnParticle(spark2);
            }

            Dust dust = Dust.NewDustPerfect(Player.Calamity().RandomDebuffVisualSpot, Main.rand.NextBool() ? 261 :(int)CalamityDusts.Brimstone);
            dust.scale = Main.rand.NextFloat(0.4f, 0.5f);
            dust.velocity = new Vector2(0, Main.rand.NextFloat(-0.5f, -2.5f)).RotatedByRandom(0.6f);
            if (dust.type == 261)
                dust.color = Color.Lerp(Color.Red, Color.Magenta, 0.65f);

        }
    }
}
